#line 1 "../main.ino"
#include <Arduino.h>
#line 1
void setup ();
void loop ();
#line 1
/*	===========================================================================
 UPC - EETAC - CSD - http://digsys.upc.edu 

 * PROJECTE MAGNET (https://magnet.cat/). 
 * Escola La Gurdia, Sant Vicen dels Horts, Baix Llobregat
 
 Documentaci: https://digsys.upc.edu/csd/P12/MAGNET/Aixeta/Control_Aixeta.html
 Arduino Uno. Xip ATmega328P
===========================================================================
 L'automatisme provoca l'accionament de la bobina de 5 V del rel. 
 L'electrovlvula de solenoide o qualsevol altra aplicaci elctrica 
 (lmpada, motor, etc.) ha de connectar-se a l'interruptor del rel. 
 Mentre raja aigua hi ha un LED intermitent

Planificaci del projecte: 

- Pas 1: Trobarem un programa per comprovar com funciona el sensor d'ultrasons.
I aix ja veurem quina biblioteca de funcions d'Arduino relacionada amb aquest 
sensor haurem d'installar i com s'haur utilitzar. 
A la pgina Arduino.cc en trobareu unes quantes. 


- Pas 2: Programarem el circuit. Hi ha un parell de tcniques:
(1) Programa descrit amb diagrama de flux d'operacions a realitzar.
Aquest programa s la traducci del diagrama de flux de la Fig. 4 (1):
https://digsys.upc.edu/csd/P12/MAGNET/Aixeta/img_diagrames.jpg


(2)(alternativa avanada). Programa de mquina d'estats finits. 
    - El temps es mesurar amb la funci millis() 
=============================================================================*/

/*	===========================================================================
	Versi 2: Clcul de la duraci del pols d'eco. Aplicaci de la frmula de 
  distancia recorreguda pel so. 
  La funci	"pulseIn()" ja ve installada per defecte a l'Arduino

https://reference.arduino.cc/reference/en/language/functions/advanced-io/pulsein/
	=========================================================================*/

/*	===========================================================================
	Constants
	=========================================================================*/
// Disposici de pins de l'Arduino
const byte Eco_pin = 4; 
const byte Gallet_pin = 3;

const byte Pilot_LED_pin = 7; 
const byte Aixeta_pin = 8;

// Perode de temps per generar la intermitncia de mig segon
const unsigned long PERIODE_TEMPS = 500;  // millisegons

const int LLINDAR_DETECCIO = 40; // 40 cm

// Com que el temps s'estableix comprant perodes PERIODE_TEMPS, aquest valor
// proposat representar 10 segons de funcionament
const byte TEMPORITZACIO_AIXETA = 10 ; //amb aquesta variable 'byte' mxim 255)

/*	===========================================================================
	Variables
	======================================================================== */
int  var_Dist;  // Distncia que separa el sensor i l'obstacle

long int var_Tp;  // duraci de l'eco


/*	===========================================================================
	Funci d'inicialitzaci
	=========================================================================*/
void setup () {
// Inicialitzem el monitor del port serie per transmetre les distncies
    Serial.begin(9600);
// Enviem el primer missatge
	Serial.println("Project MAGNET - Aixeta d'aigua");

// Configurem les entades i sortides
	pinMode(Eco_pin, INPUT);  
	pinMode(Gallet_pin, OUTPUT); 
	
	pinMode(Pilot_LED_pin, OUTPUT);  
	pinMode(Aixeta_pin, OUTPUT);	

// Iniciem la sortida que dispara el sensor 
    digitalWrite(Gallet_pin, LOW);   

// Iniciem les sortides amb l'aixeta tancada
    digitalWrite(Aixeta_pin, LOW);   // Aixeta = 0;
    digitalWrite(Pilot_LED_pin, LOW);   // Pilot = 0;

    var_Dist = 200;
      //Temporitza una mica abans de comenar. 
  delay (500);  
}

/*	===========================================================================
	Funci de lla infinit
	=========================================================================*/
void loop () {
byte i;

	// Clcul de la distncia a l'obstacle

	// En primer lloc mesurem la duraci del pols d'eco: 
		// Enviem un pols de gallet 
	digitalWrite(Gallet_pin, HIGH);
	delayMicroseconds(5);
	digitalWrite(Gallet_pin, LOW);
	delayMicroseconds(3);

// Ara calculem la duraci del pols d'eco
// Aquesta funci ens retorna la duraci del pols eco en microsegons
	var_Tp = pulseIn(Eco_pin, HIGH);

// Calculem la distncia a partir del temps en qu el so viatja 
// velocitat del so Vs = 343 m/s; 
// Distncia a l'obstacle var_D(m) = (1/2)Tp(s)Vs(m/s)
// Canviem d'unitats a cm i microsegons: 
// var_Dist s en cm; var_Tp s en microsegons
// La constant s (1/58.1) cm/microsegon
		
	var_Dist= var_Tp/58.1;

// Envia la distncia calculada al monitor srie
    Serial.print("Distncia: "); Serial.print(var_Dist); Serial.println("cm");


// Comparador
  if (var_Dist < LLINDAR_DETECCIO){   // Activaci de l'aixeta
    digitalWrite(Aixeta_pin, HIGH);   // Aixeta = 1;
									
    for (i = 0; i < TEMPORITZACIO_AIXETA; i++){			// Pilot intermitent
      digitalWrite(Pilot_LED_pin, HIGH);   // Pilot = 1;
      delay (500);                  
      digitalWrite(Pilot_LED_pin, LOW);   // Pilot = 0;
      delay (500);      
    }

  }
  digitalWrite(Pilot_LED_pin, LOW);   // Pilot = 0;
  digitalWrite(Aixeta_pin, LOW);   // Aixeta = 0;

  //Temporitza una mica abans de tornar a comenar. 
  delay (1000);  
}
